%------------------------------------------------------------------------------
% File     : COM201^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Computing Theory
% Problem  : Koenig's lemma (about infinite trees) 120
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [BH+14] Blanchette et al. (2014), Truly Modular (Co)datatypes
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : koenig__120.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.5.0, 0.33 v7.2.0, 0.50 v7.1.0
% Syntax   : Number of formulae    :  371 ( 114 unt;  74 typ;   0 def)
%            Number of atoms       :  608 ( 364 equ;   4 cnn)
%            Maximal formula atoms :    4 (   2 avg)
%            Number of connectives : 3253 (  25   ~;   3   |;  17   &;2998   @)
%                                         (   0 <=>; 210  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   20 (   5 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :  184 ( 184   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   75 (  71 usr;   9 con; 0-6 aty)
%            Number of variables   :  833 (  51   ^; 716   !;   4   ?; 833   :)
%                                         (  62  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:38:54.819
%------------------------------------------------------------------------------
%----Could-be-implicit typings (7)
thf(ty_t_Code__Numeral_Onatural,type,
    code_natural: $tType ).

thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_Stream_Ostream,type,
    stream: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Num_Onum,type,
    num: $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

%----Explicit typings (67)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Onumeral,type,
    numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ominus,type,
    minus: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ouminus,type,
    uminus: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Nat_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Oneg__numeral,type,
    neg_numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__ring__1,type,
    comm_ring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__group__add,type,
    ab_group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__add,type,
    semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocomm__monoid__diff,type,
    comm_monoid_diff: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__comm__monoid__add,type,
    cancel1352612707id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add,type,
    ordere779506340up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Code__Numeral_Onatural_Ocase__natural,type,
    code_case_natural: 
      !>[T: $tType] : ( T > ( code_natural > T ) > code_natural > T ) ).

thf(sy_c_Code__Numeral_Onatural_Osize__natural,type,
    code_size_natural: code_natural > nat ).

thf(sy_c_Fun_Ocomp,type,
    comp: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( B > C ) > ( A > B ) > A > C ) ).

thf(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_Ons,type,
    koenig_Mirabelle_ns: nat > ( stream @ nat ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_Oones,type,
    koenig973364414e_ones: stream @ nat ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_Oplus,type,
    koenig1738478187e_plus: ( stream @ nat ) > ( stream @ nat ) > ( stream @ nat ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_Oscalar,type,
    koenig1401075325scalar: nat > ( stream @ nat ) > ( stream @ nat ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_Otwos,type,
    koenig656342648e_twos: stream @ nat ).

thf(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

thf(sy_c_Num_Oinc,type,
    inc: num > num ).

thf(sy_c_Num_Oneg__numeral__class_Odbl__dec,type,
    neg_numeral_dbl_dec: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Num_Oneg__numeral__class_Odbl__inc,type,
    neg_numeral_dbl_inc: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Num_Oneg__numeral__class_Osub,type,
    neg_numeral_sub: 
      !>[A: $tType] : ( num > num > A ) ).

thf(sy_c_Num_Onum_OOne,type,
    one2: num ).

thf(sy_c_Num_Onumeral__class_Onumeral,type,
    numeral_numeral: 
      !>[A: $tType] : ( num > A ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Stream_Osdrop__while,type,
    sdrop_while: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osfilter,type,
    sfilter: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osinterleave,type,
    sinterleave: 
      !>[A: $tType] : ( ( stream @ A ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osmap2,type,
    smap2: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( stream @ A ) > ( stream @ B ) > ( stream @ C ) ) ).

thf(sy_c_Stream_Osmember,type,
    smember: 
      !>[A: $tType] : ( A > ( stream @ A ) > $o ) ).

thf(sy_c_Stream_Ostream_OSCons,type,
    sCons: 
      !>[A: $tType] : ( A > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Ostream_Ocase__stream,type,
    case_stream: 
      !>[A: $tType,B: $tType] : ( ( A > ( stream @ A ) > B ) > ( stream @ A ) > B ) ).

thf(sy_c_Stream_Ostream_Oshd,type,
    shd: 
      !>[A: $tType] : ( ( stream @ A ) > A ) ).

thf(sy_c_Stream_Ostream_Osmap,type,
    smap: 
      !>[A: $tType,Aa: $tType] : ( ( A > Aa ) > ( stream @ A ) > ( stream @ Aa ) ) ).

thf(sy_c_Stream_Ostream_Ostl,type,
    stl: 
      !>[A: $tType] : ( ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Ostream__all,type,
    stream_all: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > $o ) ).

thf(sy_c_Stream_Ostreams,type,
    streams: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( stream @ A ) ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_xs,type,
    xs: stream @ nat ).

thf(sy_v_ys,type,
    ys: stream @ nat ).

thf(sy_v_zs,type,
    zs: stream @ nat ).

%----Relevant facts (251)
thf(fact_0_plus__comm,axiom,
    ( koenig1738478187e_plus
    = ( ^ [Xs: stream @ nat,Ys: stream @ nat] : ( koenig1738478187e_plus @ Ys @ Xs ) ) ) ).

% plus_comm
thf(fact_1_scalar__plus,axiom,
    ! [N: nat,Xs2: stream @ nat,Ys2: stream @ nat] :
      ( ( koenig1401075325scalar @ N @ ( koenig1738478187e_plus @ Xs2 @ Ys2 ) )
      = ( koenig1738478187e_plus @ ( koenig1401075325scalar @ N @ Xs2 ) @ ( koenig1401075325scalar @ N @ Ys2 ) ) ) ).

% scalar_plus
thf(fact_2_plus_Osimps_I2_J,axiom,
    ! [Xs2: stream @ nat,Ys2: stream @ nat] :
      ( ( stl @ nat @ ( koenig1738478187e_plus @ Xs2 @ Ys2 ) )
      = ( koenig1738478187e_plus @ ( stl @ nat @ Xs2 ) @ ( stl @ nat @ Ys2 ) ) ) ).

% plus.simps(2)
thf(fact_3_plus_Osimps_I1_J,axiom,
    ! [Xs2: stream @ nat,Ys2: stream @ nat] :
      ( ( shd @ nat @ ( koenig1738478187e_plus @ Xs2 @ Ys2 ) )
      = ( plus_plus @ nat @ ( shd @ nat @ Xs2 ) @ ( shd @ nat @ Ys2 ) ) ) ).

% plus.simps(1)
thf(fact_4_add__left__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( plus_plus @ A @ A2 @ C2 ) )
          = ( B2 = C2 ) ) ) ).

% add_left_cancel
thf(fact_5_add__right__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = ( plus_plus @ A @ C2 @ A2 ) )
          = ( B2 = C2 ) ) ) ).

% add_right_cancel
thf(fact_6_stream_Oexpand,axiom,
    ! [A: $tType,Stream: stream @ A,Stream2: stream @ A] :
      ( ( ( ( shd @ A @ Stream )
          = ( shd @ A @ Stream2 ) )
        & ( ( stl @ A @ Stream )
          = ( stl @ A @ Stream2 ) ) )
     => ( Stream = Stream2 ) ) ).

% stream.expand
thf(fact_7_stream_Ocoinduct,axiom,
    ! [A: $tType,R: ( stream @ A ) > ( stream @ A ) > $o,Stream: stream @ A,Stream2: stream @ A] :
      ( ( R @ Stream @ Stream2 )
     => ( ! [Stream3: stream @ A,Stream4: stream @ A] :
            ( ( R @ Stream3 @ Stream4 )
           => ( ( ( shd @ A @ Stream3 )
                = ( shd @ A @ Stream4 ) )
              & ( R @ ( stl @ A @ Stream3 ) @ ( stl @ A @ Stream4 ) ) ) )
       => ( Stream = Stream2 ) ) ) ).

% stream.coinduct
thf(fact_8_stream_Ocoinduct__strong,axiom,
    ! [A: $tType,R: ( stream @ A ) > ( stream @ A ) > $o,Stream: stream @ A,Stream2: stream @ A] :
      ( ( R @ Stream @ Stream2 )
     => ( ! [Stream3: stream @ A,Stream4: stream @ A] :
            ( ( R @ Stream3 @ Stream4 )
           => ( ( ( shd @ A @ Stream3 )
                = ( shd @ A @ Stream4 ) )
              & ( ( R @ ( stl @ A @ Stream3 ) @ ( stl @ A @ Stream4 ) )
                | ( ( stl @ A @ Stream3 )
                  = ( stl @ A @ Stream4 ) ) ) ) )
       => ( Stream = Stream2 ) ) ) ).

% stream.coinduct_strong
thf(fact_9_plus_Ocode,axiom,
    ( koenig1738478187e_plus
    = ( ^ [Xs: stream @ nat,Ys: stream @ nat] : ( sCons @ nat @ ( plus_plus @ nat @ ( shd @ nat @ Xs ) @ ( shd @ nat @ Ys ) ) @ ( koenig1738478187e_plus @ ( stl @ nat @ Xs ) @ ( stl @ nat @ Ys ) ) ) ) ) ).

% plus.code
thf(fact_10_twos_Osimps_I2_J,axiom,
    ( ( stl @ nat @ koenig656342648e_twos )
    = koenig656342648e_twos ) ).

% twos.simps(2)
thf(fact_11_ones_Osimps_I2_J,axiom,
    ( ( stl @ nat @ koenig973364414e_ones )
    = koenig973364414e_ones ) ).

% ones.simps(2)
thf(fact_12_nat__add__left__cancel,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ K @ M )
        = ( plus_plus @ nat @ K @ N ) )
      = ( M = N ) ) ).

% nat_add_left_cancel
thf(fact_13_nat__add__right__cancel,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ K )
        = ( plus_plus @ nat @ N @ K ) )
      = ( M = N ) ) ).

% nat_add_right_cancel
thf(fact_14_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% ab_semigroup_add_class.add_ac(1)
thf(fact_15_is__num__normalize_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% is_num_normalize(1)
thf(fact_16_stream_Oinject,axiom,
    ! [A: $tType,X1: A,X2: stream @ A,Y1: A,Y2: stream @ A] :
      ( ( ( sCons @ A @ X1 @ X2 )
        = ( sCons @ A @ Y1 @ Y2 ) )
      = ( ( X1 = Y1 )
        & ( X2 = Y2 ) ) ) ).

% stream.inject
thf(fact_17_stream_Ocollapse,axiom,
    ! [A: $tType,Stream: stream @ A] :
      ( ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) )
      = Stream ) ).

% stream.collapse
thf(fact_18_stream_Oexhaust,axiom,
    ! [A: $tType,Y: stream @ A] :
      ~ ! [X12: A,X22: stream @ A] :
          ( Y
         != ( sCons @ A @ X12 @ X22 ) ) ).

% stream.exhaust
thf(fact_19_stream_Osel_I2_J,axiom,
    ! [A: $tType,X1: A,X2: stream @ A] :
      ( ( stl @ A @ ( sCons @ A @ X1 @ X2 ) )
      = X2 ) ).

% stream.sel(2)
thf(fact_20_stream_Osel_I1_J,axiom,
    ! [A: $tType,X1: A,X2: stream @ A] :
      ( ( shd @ A @ ( sCons @ A @ X1 @ X2 ) )
      = X1 ) ).

% stream.sel(1)
thf(fact_21_stream_Oexhaust__sel,axiom,
    ! [A: $tType,Stream: stream @ A] :
      ( Stream
      = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ).

% stream.exhaust_sel
thf(fact_22_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = ( plus_plus @ A @ C2 @ A2 ) )
         => ( B2 = C2 ) ) ) ).

% add_right_imp_eq
thf(fact_23_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( plus_plus @ A @ A2 @ C2 ) )
         => ( B2 = C2 ) ) ) ).

% add_left_imp_eq
thf(fact_24_add_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C2: A] :
          ( ( plus_plus @ A @ B2 @ ( plus_plus @ A @ A2 @ C2 ) )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% add.left_commute
thf(fact_25_add_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A3: A,B3: A] : ( plus_plus @ A @ B3 @ A3 ) ) ) ) ).

% add.commute
thf(fact_26_add_Oright__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = ( plus_plus @ A @ C2 @ A2 ) )
          = ( B2 = C2 ) ) ) ).

% add.right_cancel
thf(fact_27_add_Oleft__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( plus_plus @ A @ A2 @ C2 ) )
          = ( B2 = C2 ) ) ) ).

% add.left_cancel
thf(fact_28_add_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% add.assoc
thf(fact_29_add__mono__thms__linordered__semiring_I4_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( K = L ) )
         => ( ( plus_plus @ A @ I @ K )
            = ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(4)
thf(fact_30_ns__def,axiom,
    ( koenig_Mirabelle_ns
    = ( ^ [N2: nat] : ( koenig1401075325scalar @ N2 @ koenig973364414e_ones ) ) ) ).

% ns_def
thf(fact_31_smember__code,axiom,
    ! [A: $tType,X: A,Y: A,S: stream @ A] :
      ( ( smember @ A @ X @ ( sCons @ A @ Y @ S ) )
      = ( ( X != Y )
       => ( smember @ A @ X @ S ) ) ) ).

% smember_code
thf(fact_32_sinterleave_Ocode,axiom,
    ! [A: $tType] :
      ( ( sinterleave @ A )
      = ( ^ [S1: stream @ A,S2: stream @ A] : ( sCons @ A @ ( shd @ A @ S1 ) @ ( sinterleave @ A @ S2 @ ( stl @ A @ S1 ) ) ) ) ) ).

% sinterleave.code
thf(fact_33_stream_Osplit__sel__asm,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F: A > ( stream @ A ) > B,Stream: stream @ A] :
      ( ( P @ ( case_stream @ A @ B @ F @ Stream ) )
      = ( ~ ( ( Stream
              = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) )
            & ~ ( P @ ( F @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ) ) ) ).

% stream.split_sel_asm
thf(fact_34_stream_Osplit__sel,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F: A > ( stream @ A ) > B,Stream: stream @ A] :
      ( ( P @ ( case_stream @ A @ B @ F @ Stream ) )
      = ( ( Stream
          = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) )
       => ( P @ ( F @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ) ) ).

% stream.split_sel
thf(fact_35_smap2_Ocode,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( smap2 @ A @ B @ C )
      = ( ^ [F2: A > B > C,S1: stream @ A,S2: stream @ B] : ( sCons @ C @ ( F2 @ ( shd @ A @ S1 ) @ ( shd @ B @ S2 ) ) @ ( smap2 @ A @ B @ C @ F2 @ ( stl @ A @ S1 ) @ ( stl @ B @ S2 ) ) ) ) ) ).

% smap2.code
thf(fact_36_stream_Ocase__eq__if,axiom,
    ! [B: $tType,A: $tType] :
      ( ( case_stream @ A @ B )
      = ( ^ [F2: A > ( stream @ A ) > B,Stream5: stream @ A] : ( F2 @ ( shd @ A @ Stream5 ) @ ( stl @ A @ Stream5 ) ) ) ) ).

% stream.case_eq_if
thf(fact_37_sdrop__while_Osimps,axiom,
    ! [A: $tType] :
      ( ( sdrop_while @ A )
      = ( ^ [P2: A > $o,S3: stream @ A] : ( if @ ( stream @ A ) @ ( P2 @ ( shd @ A @ S3 ) ) @ ( sdrop_while @ A @ P2 @ ( stl @ A @ S3 ) ) @ S3 ) ) ) ).

% sdrop_while.simps
thf(fact_38_ones_Ocode,axiom,
    ( koenig973364414e_ones
    = ( sCons @ nat @ ( one_one @ nat ) @ koenig973364414e_ones ) ) ).

% ones.code
thf(fact_39_smap__ctr,axiom,
    ! [B: $tType,A: $tType,F: B > A,S: stream @ B,X: A,S4: stream @ A] :
      ( ( ( smap @ B @ A @ F @ S )
        = ( sCons @ A @ X @ S4 ) )
      = ( ( ( F @ ( shd @ B @ S ) )
          = X )
        & ( ( smap @ B @ A @ F @ ( stl @ B @ S ) )
          = S4 ) ) ) ).

% smap_ctr
thf(fact_40_stream_Omap__sel_I2_J,axiom,
    ! [B: $tType,A: $tType,F: A > B,A2: stream @ A] :
      ( ( stl @ B @ ( smap @ A @ B @ F @ A2 ) )
      = ( smap @ A @ B @ F @ ( stl @ A @ A2 ) ) ) ).

% stream.map_sel(2)
thf(fact_41_stream_Omap__sel_I1_J,axiom,
    ! [B: $tType,A: $tType,F: A > B,A2: stream @ A] :
      ( ( shd @ B @ ( smap @ A @ B @ F @ A2 ) )
      = ( F @ ( shd @ A @ A2 ) ) ) ).

% stream.map_sel(1)
thf(fact_42_one__reorient,axiom,
    ! [A: $tType] :
      ( ( one @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( ( one_one @ A )
            = X )
          = ( X
            = ( one_one @ A ) ) ) ) ).

% one_reorient
thf(fact_43_stream_Omap,axiom,
    ! [B: $tType,A: $tType,F: A > B,X1: A,X2: stream @ A] :
      ( ( smap @ A @ B @ F @ ( sCons @ A @ X1 @ X2 ) )
      = ( sCons @ B @ ( F @ X1 ) @ ( smap @ A @ B @ F @ X2 ) ) ) ).

% stream.map
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X3: A] : ( member @ A @ X3 @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X4: A] :
          ( ( P @ X4 )
          = ( Q @ X4 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_47_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X4: A] :
          ( ( F @ X4 )
          = ( G @ X4 ) )
     => ( F = G ) ) ).

% ext
thf(fact_48_smap2_Osimps_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,F: A > B > C,S12: stream @ A,S22: stream @ B] :
      ( ( stl @ C @ ( smap2 @ A @ B @ C @ F @ S12 @ S22 ) )
      = ( smap2 @ A @ B @ C @ F @ ( stl @ A @ S12 ) @ ( stl @ B @ S22 ) ) ) ).

% smap2.simps(2)
thf(fact_49_smap2_Osimps_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,F: A > B > C,S12: stream @ A,S22: stream @ B] :
      ( ( shd @ C @ ( smap2 @ A @ B @ C @ F @ S12 @ S22 ) )
      = ( F @ ( shd @ A @ S12 ) @ ( shd @ B @ S22 ) ) ) ).

% smap2.simps(1)
thf(fact_50_smap2__unfold,axiom,
    ! [B: $tType,A: $tType,C: $tType,F: B > C > A,A2: B,S12: stream @ B,B2: C,S22: stream @ C] :
      ( ( smap2 @ B @ C @ A @ F @ ( sCons @ B @ A2 @ S12 ) @ ( sCons @ C @ B2 @ S22 ) )
      = ( sCons @ A @ ( F @ A2 @ B2 ) @ ( smap2 @ B @ C @ A @ F @ S12 @ S22 ) ) ) ).

% smap2_unfold
thf(fact_51_sdrop__while__SCons,axiom,
    ! [A: $tType,P: A > $o,A2: A,S: stream @ A] :
      ( ( ( P @ A2 )
       => ( ( sdrop_while @ A @ P @ ( sCons @ A @ A2 @ S ) )
          = ( sdrop_while @ A @ P @ S ) ) )
      & ( ~ ( P @ A2 )
       => ( ( sdrop_while @ A @ P @ ( sCons @ A @ A2 @ S ) )
          = ( sCons @ A @ A2 @ S ) ) ) ) ).

% sdrop_while_SCons
thf(fact_52_stream_Ocase,axiom,
    ! [B: $tType,A: $tType,F: A > ( stream @ A ) > B,X1: A,X2: stream @ A] :
      ( ( case_stream @ A @ B @ F @ ( sCons @ A @ X1 @ X2 ) )
      = ( F @ X1 @ X2 ) ) ).

% stream.case
thf(fact_53_sinterleave_Osimps_I2_J,axiom,
    ! [A: $tType,S12: stream @ A,S22: stream @ A] :
      ( ( stl @ A @ ( sinterleave @ A @ S12 @ S22 ) )
      = ( sinterleave @ A @ S22 @ ( stl @ A @ S12 ) ) ) ).

% sinterleave.simps(2)
thf(fact_54_sinterleave_Osimps_I1_J,axiom,
    ! [A: $tType,S12: stream @ A,S22: stream @ A] :
      ( ( shd @ A @ ( sinterleave @ A @ S12 @ S22 ) )
      = ( shd @ A @ S12 ) ) ).

% sinterleave.simps(1)
thf(fact_55_sinterleave__code,axiom,
    ! [A: $tType,X: A,S12: stream @ A,S22: stream @ A] :
      ( ( sinterleave @ A @ ( sCons @ A @ X @ S12 ) @ S22 )
      = ( sCons @ A @ X @ ( sinterleave @ A @ S22 @ S12 ) ) ) ).

% sinterleave_code
thf(fact_56_ones_Osimps_I1_J,axiom,
    ( ( shd @ nat @ koenig973364414e_ones )
    = ( one_one @ nat ) ) ).

% ones.simps(1)
thf(fact_57_dbl__inc__def,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl_inc @ A )
        = ( ^ [X3: A] : ( plus_plus @ A @ ( plus_plus @ A @ X3 @ X3 ) @ ( one_one @ A ) ) ) ) ) ).

% dbl_inc_def
thf(fact_58_one__natural_Orsp,axiom,
    ( ( one_one @ nat )
    = ( one_one @ nat ) ) ).

% one_natural.rsp
thf(fact_59_dbl__dec__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl_dec @ A @ ( one_one @ A ) )
        = ( one_one @ A ) ) ) ).

% dbl_dec_simps(3)
thf(fact_60_linordered__field__class_Osign__simps_I28_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C2: A] :
          ( ( plus_plus @ A @ B2 @ ( plus_plus @ A @ A2 @ C2 ) )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% linordered_field_class.sign_simps(28)
thf(fact_61_linordered__field__class_Osign__simps_I27_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A3: A,B3: A] : ( plus_plus @ A @ B3 @ A3 ) ) ) ) ).

% linordered_field_class.sign_simps(27)
thf(fact_62_linordered__field__class_Osign__simps_I26_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% linordered_field_class.sign_simps(26)
thf(fact_63_semiring__normalization__rules_I25_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,C2: A,D: A] :
          ( ( plus_plus @ A @ A2 @ ( plus_plus @ A @ C2 @ D ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C2 ) @ D ) ) ) ).

% semiring_normalization_rules(25)
thf(fact_64_semiring__normalization__rules_I24_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A3: A,C3: A] : ( plus_plus @ A @ C3 @ A3 ) ) ) ) ).

% semiring_normalization_rules(24)
thf(fact_65_semiring__normalization__rules_I20_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A,D: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ ( plus_plus @ A @ C2 @ D ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C2 ) @ ( plus_plus @ A @ B2 @ D ) ) ) ) ).

% semiring_normalization_rules(20)
thf(fact_66_semiring__normalization__rules_I21_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% semiring_normalization_rules(21)
thf(fact_67_semiring__normalization__rules_I22_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,C2: A,D: A] :
          ( ( plus_plus @ A @ A2 @ ( plus_plus @ A @ C2 @ D ) )
          = ( plus_plus @ A @ C2 @ ( plus_plus @ A @ A2 @ D ) ) ) ) ).

% semiring_normalization_rules(22)
thf(fact_68_semiring__normalization__rules_I23_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C2 ) @ B2 ) ) ) ).

% semiring_normalization_rules(23)
thf(fact_69_dbl__dec__def,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl_dec @ A )
        = ( ^ [X3: A] : ( minus_minus @ A @ ( plus_plus @ A @ X3 @ X3 ) @ ( one_one @ A ) ) ) ) ) ).

% dbl_dec_def
thf(fact_70_dbl__inc__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl_inc @ A @ ( zero_zero @ A ) )
        = ( one_one @ A ) ) ) ).

% dbl_inc_simps(2)
thf(fact_71_dbl__inc__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl_inc @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
        = ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% dbl_inc_simps(4)
thf(fact_72_sfilter_Ocode,axiom,
    ! [A: $tType] :
      ( ( sfilter @ A )
      = ( ^ [P2: A > $o,S3: stream @ A] : ( sCons @ A @ ( shd @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P2 ) @ S3 ) ) @ ( sfilter @ A @ P2 @ ( stl @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P2 ) @ S3 ) ) ) ) ) ) ).

% sfilter.code
thf(fact_73_in__streams,axiom,
    ! [A: $tType,S: stream @ A,S5: set @ A] :
      ( ( member @ ( stream @ A ) @ ( stl @ A @ S ) @ ( streams @ A @ S5 ) )
     => ( ( member @ A @ ( shd @ A @ S ) @ S5 )
       => ( member @ ( stream @ A ) @ S @ ( streams @ A @ S5 ) ) ) ) ).

% in_streams
thf(fact_74_streamsE,axiom,
    ! [A: $tType,S: stream @ A,A4: set @ A] :
      ( ( member @ ( stream @ A ) @ S @ ( streams @ A @ A4 ) )
     => ~ ( ( member @ A @ ( shd @ A @ S ) @ A4 )
         => ~ ( member @ ( stream @ A ) @ ( stl @ A @ S ) @ ( streams @ A @ A4 ) ) ) ) ).

% streamsE
thf(fact_75_stream__all__Stream,axiom,
    ! [A: $tType,P: A > $o,X: A,X5: stream @ A] :
      ( ( stream_all @ A @ P @ ( sCons @ A @ X @ X5 ) )
      = ( ( P @ X )
        & ( stream_all @ A @ P @ X5 ) ) ) ).

% stream_all_Stream
thf(fact_76_neg__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = ( uminus_uminus @ A @ B2 ) )
          = ( A2 = B2 ) ) ) ).

% neg_equal_iff_equal
thf(fact_77_add_Oinverse__inverse,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( uminus_uminus @ A @ ( uminus_uminus @ A @ A2 ) )
          = A2 ) ) ).

% add.inverse_inverse
thf(fact_78_diff__diff__left,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( minus_minus @ nat @ ( minus_minus @ nat @ I @ J ) @ K )
      = ( minus_minus @ nat @ I @ ( plus_plus @ nat @ J @ K ) ) ) ).

% diff_diff_left
thf(fact_79_add__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        & ( N
          = ( zero_zero @ nat ) ) ) ) ).

% add_is_0
thf(fact_80_Nat_Oadd__0__right,axiom,
    ! [M: nat] :
      ( ( plus_plus @ nat @ M @ ( zero_zero @ nat ) )
      = M ) ).

% Nat.add_0_right
thf(fact_81_add_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.left_neutral
thf(fact_82_add_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.right_neutral
thf(fact_83_double__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ( plus_plus @ A @ A2 @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero
thf(fact_84_double__zero__sym,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( plus_plus @ A @ A2 @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero_sym
thf(fact_85_add__cancel__left__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = A2 )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_left
thf(fact_86_add__cancel__left__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = A2 )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_right
thf(fact_87_add__cancel__right__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( plus_plus @ A @ B2 @ A2 ) )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_left
thf(fact_88_add__cancel__right__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( plus_plus @ A @ A2 @ B2 ) )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_right
thf(fact_89_cancel__comm__monoid__add__class_Odiff__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ A2 )
          = ( zero_zero @ A ) ) ) ).

% cancel_comm_monoid_add_class.diff_cancel
thf(fact_90_diff__zero,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% diff_zero
thf(fact_91_zero__diff,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_diff @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( minus_minus @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% zero_diff
thf(fact_92_diff__0__right,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% diff_0_right
thf(fact_93_diff__self,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ A2 )
          = ( zero_zero @ A ) ) ) ).

% diff_self
thf(fact_94_neg__equal__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = A2 )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% neg_equal_zero
thf(fact_95_equal__neg__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( A2
            = ( uminus_uminus @ A @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% equal_neg_zero
thf(fact_96_neg__equal__0__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% neg_equal_0_iff_equal
thf(fact_97_neg__0__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( uminus_uminus @ A @ A2 ) )
          = ( ( zero_zero @ A )
            = A2 ) ) ) ).

% neg_0_equal_iff_equal
thf(fact_98_add_Oinverse__neutral,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ( ( uminus_uminus @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% add.inverse_neutral
thf(fact_99_add__diff__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( minus_minus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ B2 )
          = A2 ) ) ).

% add_diff_cancel
thf(fact_100_diff__add__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( plus_plus @ A @ ( minus_minus @ A @ A2 @ B2 ) @ B2 )
          = A2 ) ) ).

% diff_add_cancel
thf(fact_101_add__diff__cancel__left,axiom,
    ! [A: $tType] :
      ( ( cancel146912293up_add @ A @ ( type2 @ A ) )
     => ! [C2: A,A2: A,B2: A] :
          ( ( minus_minus @ A @ ( plus_plus @ A @ C2 @ A2 ) @ ( plus_plus @ A @ C2 @ B2 ) )
          = ( minus_minus @ A @ A2 @ B2 ) ) ) ).

% add_diff_cancel_left
thf(fact_102_add__diff__cancel__left_H,axiom,
    ! [A: $tType] :
      ( ( cancel146912293up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( minus_minus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ A2 )
          = B2 ) ) ).

% add_diff_cancel_left'
thf(fact_103_add__diff__cancel__right,axiom,
    ! [A: $tType] :
      ( ( cancel146912293up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,C2: A,B2: A] :
          ( ( minus_minus @ A @ ( plus_plus @ A @ A2 @ C2 ) @ ( plus_plus @ A @ B2 @ C2 ) )
          = ( minus_minus @ A @ A2 @ B2 ) ) ) ).

% add_diff_cancel_right
thf(fact_104_add__diff__cancel__right_H,axiom,
    ! [A: $tType] :
      ( ( cancel146912293up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( minus_minus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ B2 )
          = A2 ) ) ).

% add_diff_cancel_right'
thf(fact_105_add__minus__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( plus_plus @ A @ A2 @ ( plus_plus @ A @ ( uminus_uminus @ A @ A2 ) @ B2 ) )
          = B2 ) ) ).

% add_minus_cancel
thf(fact_106_minus__add__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ A2 ) @ ( plus_plus @ A @ A2 @ B2 ) )
          = B2 ) ) ).

% minus_add_cancel
thf(fact_107_minus__add__distrib,axiom,
    ! [A: $tType] :
      ( ( ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( uminus_uminus @ A @ ( plus_plus @ A @ A2 @ B2 ) )
          = ( plus_plus @ A @ ( uminus_uminus @ A @ A2 ) @ ( uminus_uminus @ A @ B2 ) ) ) ) ).

% minus_add_distrib
thf(fact_108_minus__diff__eq,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( uminus_uminus @ A @ ( minus_minus @ A @ A2 @ B2 ) )
          = ( minus_minus @ A @ B2 @ A2 ) ) ) ).

% minus_diff_eq
thf(fact_109_diff__add__zero,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_diff @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( minus_minus @ A @ A2 @ ( plus_plus @ A @ A2 @ B2 ) )
          = ( zero_zero @ A ) ) ) ).

% diff_add_zero
thf(fact_110_add_Oleft__inverse,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ A2 ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% add.left_inverse
thf(fact_111_add_Oright__inverse,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( uminus_uminus @ A @ A2 ) )
          = ( zero_zero @ A ) ) ) ).

% add.right_inverse
thf(fact_112_diff__numeral__special_I9_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( minus_minus @ A @ ( one_one @ A ) @ ( one_one @ A ) )
        = ( zero_zero @ A ) ) ) ).

% diff_numeral_special(9)
thf(fact_113_diff__0,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( minus_minus @ A @ ( zero_zero @ A ) @ A2 )
          = ( uminus_uminus @ A @ A2 ) ) ) ).

% diff_0
thf(fact_114_diff__minus__eq__add,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( minus_minus @ A @ A2 @ ( uminus_uminus @ A @ B2 ) )
          = ( plus_plus @ A @ A2 @ B2 ) ) ) ).

% diff_minus_eq_add
thf(fact_115_uminus__add__conv__diff,axiom,
    ! [A: $tType] :
      ( ( ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ A2 ) @ B2 )
          = ( minus_minus @ A @ B2 @ A2 ) ) ) ).

% uminus_add_conv_diff
thf(fact_116_add__neg__numeral__special_I8_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ ( one_one @ A ) )
        = ( zero_zero @ A ) ) ) ).

% add_neg_numeral_special(8)
thf(fact_117_add__neg__numeral__special_I7_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A @ ( one_one @ A ) @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
        = ( zero_zero @ A ) ) ) ).

% add_neg_numeral_special(7)
thf(fact_118_diff__numeral__special_I12_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( minus_minus @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
        = ( zero_zero @ A ) ) ) ).

% diff_numeral_special(12)
thf(fact_119_dbl__dec__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl_dec @ A @ ( zero_zero @ A ) )
        = ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% dbl_dec_simps(2)
thf(fact_120_zero__neq__neg__one,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ( ( zero_zero @ A )
       != ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% zero_neq_neg_one
thf(fact_121_ring__normalization__rules_I2_J,axiom,
    ! [A: $tType] :
      ( ( comm_ring_1 @ A @ ( type2 @ A ) )
     => ( ( minus_minus @ A )
        = ( ^ [X3: A,Y3: A] : ( plus_plus @ A @ X3 @ ( uminus_uminus @ A @ Y3 ) ) ) ) ) ).

% ring_normalization_rules(2)
thf(fact_122_diff__conv__add__uminus,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ( ( minus_minus @ A )
        = ( ^ [A3: A,B3: A] : ( plus_plus @ A @ A3 @ ( uminus_uminus @ A @ B3 ) ) ) ) ) ).

% diff_conv_add_uminus
thf(fact_123_ab__group__add__class_Oab__diff__conv__add__uminus,axiom,
    ! [A: $tType] :
      ( ( ab_group_add @ A @ ( type2 @ A ) )
     => ( ( minus_minus @ A )
        = ( ^ [A3: A,B3: A] : ( plus_plus @ A @ A3 @ ( uminus_uminus @ A @ B3 ) ) ) ) ) ).

% ab_group_add_class.ab_diff_conv_add_uminus
thf(fact_124_diff__right__commute,axiom,
    ! [A: $tType] :
      ( ( cancel146912293up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,C2: A,B2: A] :
          ( ( minus_minus @ A @ ( minus_minus @ A @ A2 @ C2 ) @ B2 )
          = ( minus_minus @ A @ ( minus_minus @ A @ A2 @ B2 ) @ C2 ) ) ) ).

% diff_right_commute
thf(fact_125_minus__equation__iff,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = B2 )
          = ( ( uminus_uminus @ A @ B2 )
            = A2 ) ) ) ).

% minus_equation_iff
thf(fact_126_equation__minus__iff,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( uminus_uminus @ A @ B2 ) )
          = ( B2
            = ( uminus_uminus @ A @ A2 ) ) ) ) ).

% equation_minus_iff
thf(fact_127_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ( ( ^ [Y4: A,Z: A] : ( Y4 = Z ) )
        = ( ^ [A3: A,B3: A] :
              ( ( minus_minus @ A @ A3 @ B3 )
              = ( zero_zero @ A ) ) ) ) ) ).

% eq_iff_diff_eq_0
thf(fact_128_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A,D: A] :
          ( ( ( minus_minus @ A @ A2 @ B2 )
            = ( minus_minus @ A @ C2 @ D ) )
         => ( ( A2 = B2 )
            = ( C2 = D ) ) ) ) ).

% diff_eq_diff_eq
thf(fact_129_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( ( zero_zero @ A )
            = X )
          = ( X
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_130_diff__add__0,axiom,
    ! [N: nat,M: nat] :
      ( ( minus_minus @ nat @ N @ ( plus_plus @ nat @ N @ M ) )
      = ( zero_zero @ nat ) ) ).

% diff_add_0
thf(fact_131_add__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( zero_zero @ A ) )
          = ( B2
            = ( uminus_uminus @ A @ A2 ) ) ) ) ).

% add_eq_0_iff
thf(fact_132_ab__group__add__class_Oab__left__minus,axiom,
    ! [A: $tType] :
      ( ( ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ A2 ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% ab_group_add_class.ab_left_minus
thf(fact_133_add_Oinverse__unique,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( zero_zero @ A ) )
         => ( ( uminus_uminus @ A @ A2 )
            = B2 ) ) ) ).

% add.inverse_unique
thf(fact_134_eq__neg__iff__add__eq__0,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( uminus_uminus @ A @ B2 ) )
          = ( ( plus_plus @ A @ A2 @ B2 )
            = ( zero_zero @ A ) ) ) ) ).

% eq_neg_iff_add_eq_0
thf(fact_135_neg__eq__iff__add__eq__0,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = B2 )
          = ( ( plus_plus @ A @ A2 @ B2 )
            = ( zero_zero @ A ) ) ) ) ).

% neg_eq_iff_add_eq_0
thf(fact_136_diff__eq__eq,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ( minus_minus @ A @ A2 @ B2 )
            = C2 )
          = ( A2
            = ( plus_plus @ A @ C2 @ B2 ) ) ) ) ).

% diff_eq_eq
thf(fact_137_eq__diff__eq,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,C2: A,B2: A] :
          ( ( A2
            = ( minus_minus @ A @ C2 @ B2 ) )
          = ( ( plus_plus @ A @ A2 @ B2 )
            = C2 ) ) ) ).

% eq_diff_eq
thf(fact_138_add__diff__eq,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ A2 @ ( minus_minus @ A @ B2 @ C2 ) )
          = ( minus_minus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 ) ) ) ).

% add_diff_eq
thf(fact_139_diff__diff__eq2,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( minus_minus @ A @ A2 @ ( minus_minus @ A @ B2 @ C2 ) )
          = ( minus_minus @ A @ ( plus_plus @ A @ A2 @ C2 ) @ B2 ) ) ) ).

% diff_diff_eq2
thf(fact_140_diff__add__eq,axiom,
    ! [A: $tType] :
      ( ( ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( minus_minus @ A @ A2 @ B2 ) @ C2 )
          = ( minus_minus @ A @ ( plus_plus @ A @ A2 @ C2 ) @ B2 ) ) ) ).

% diff_add_eq
thf(fact_141_diff__add__eq__diff__diff__swap,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( minus_minus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) )
          = ( minus_minus @ A @ ( minus_minus @ A @ A2 @ C2 ) @ B2 ) ) ) ).

% diff_add_eq_diff_diff_swap
thf(fact_142_diff__diff__add,axiom,
    ! [A: $tType] :
      ( ( cancel146912293up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( minus_minus @ A @ ( minus_minus @ A @ A2 @ B2 ) @ C2 )
          = ( minus_minus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% diff_diff_add
thf(fact_143_add__implies__diff,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [C2: A,B2: A,A2: A] :
          ( ( ( plus_plus @ A @ C2 @ B2 )
            = A2 )
         => ( C2
            = ( minus_minus @ A @ A2 @ B2 ) ) ) ) ).

% add_implies_diff
thf(fact_144_linordered__field__class_Osign__simps_I29_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ A2 @ ( minus_minus @ A @ B2 @ C2 ) )
          = ( minus_minus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 ) ) ) ).

% linordered_field_class.sign_simps(29)
thf(fact_145_linordered__field__class_Osign__simps_I30_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ( minus_minus @ A @ A2 @ B2 )
            = C2 )
          = ( A2
            = ( plus_plus @ A @ C2 @ B2 ) ) ) ) ).

% linordered_field_class.sign_simps(30)
thf(fact_146_linordered__field__class_Osign__simps_I31_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,C2: A,B2: A] :
          ( ( A2
            = ( minus_minus @ A @ C2 @ B2 ) )
          = ( ( plus_plus @ A @ A2 @ B2 )
            = C2 ) ) ) ).

% linordered_field_class.sign_simps(31)
thf(fact_147_linordered__field__class_Osign__simps_I32_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( minus_minus @ A @ A2 @ ( minus_minus @ A @ B2 @ C2 ) )
          = ( minus_minus @ A @ ( plus_plus @ A @ A2 @ C2 ) @ B2 ) ) ) ).

% linordered_field_class.sign_simps(32)
thf(fact_148_linordered__field__class_Osign__simps_I33_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( minus_minus @ A @ ( minus_minus @ A @ A2 @ B2 ) @ C2 )
          = ( minus_minus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% linordered_field_class.sign_simps(33)
thf(fact_149_linordered__field__class_Osign__simps_I34_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( minus_minus @ A @ A2 @ B2 ) @ C2 )
          = ( minus_minus @ A @ ( plus_plus @ A @ A2 @ C2 ) @ B2 ) ) ) ).

% linordered_field_class.sign_simps(34)
thf(fact_150_is__num__normalize_I8_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( uminus_uminus @ A @ ( plus_plus @ A @ A2 @ B2 ) )
          = ( plus_plus @ A @ ( uminus_uminus @ A @ B2 ) @ ( uminus_uminus @ A @ A2 ) ) ) ) ).

% is_num_normalize(8)
thf(fact_151_add_Oinverse__distrib__swap,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( uminus_uminus @ A @ ( plus_plus @ A @ A2 @ B2 ) )
          = ( plus_plus @ A @ ( uminus_uminus @ A @ B2 ) @ ( uminus_uminus @ A @ A2 ) ) ) ) ).

% add.inverse_distrib_swap
thf(fact_152_one__neq__neg__one,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ( ( one_one @ A )
       != ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% one_neq_neg_one
thf(fact_153_Nat_Odiff__cancel,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( minus_minus @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( minus_minus @ nat @ M @ N ) ) ).

% Nat.diff_cancel
thf(fact_154_diff__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( minus_minus @ nat @ ( plus_plus @ nat @ M @ K ) @ ( plus_plus @ nat @ N @ K ) )
      = ( minus_minus @ nat @ M @ N ) ) ).

% diff_cancel2
thf(fact_155_diff__add__inverse,axiom,
    ! [N: nat,M: nat] :
      ( ( minus_minus @ nat @ ( plus_plus @ nat @ N @ M ) @ N )
      = M ) ).

% diff_add_inverse
thf(fact_156_diff__add__inverse2,axiom,
    ! [M: nat,N: nat] :
      ( ( minus_minus @ nat @ ( plus_plus @ nat @ M @ N ) @ N )
      = M ) ).

% diff_add_inverse2
thf(fact_157_stream_Omap__comp,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: B > C,F: A > B,V: stream @ A] :
      ( ( smap @ B @ C @ G @ ( smap @ A @ B @ F @ V ) )
      = ( smap @ A @ C @ ( comp @ B @ C @ A @ G @ F ) @ V ) ) ).

% stream.map_comp
thf(fact_158_comm__monoid__add__class_Oadd__0,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% comm_monoid_add_class.add_0
thf(fact_159_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.comm_neutral
thf(fact_160_add_Ogroup__left__neutral,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.group_left_neutral
thf(fact_161_add__eq__0__iff__both__eq__0,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ( plus_plus @ A @ X @ Y )
            = ( zero_zero @ A ) )
          = ( ( X
              = ( zero_zero @ A ) )
            & ( Y
              = ( zero_zero @ A ) ) ) ) ) ).

% add_eq_0_iff_both_eq_0
thf(fact_162_add__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( B2
            = ( plus_plus @ A @ B2 @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% add_0_iff
thf(fact_163_semiring__normalization__rules_I5_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% semiring_normalization_rules(5)
thf(fact_164_semiring__normalization__rules_I6_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% semiring_normalization_rules(6)
thf(fact_165_plus__nat_Oadd__0,axiom,
    ! [N: nat] :
      ( ( plus_plus @ nat @ ( zero_zero @ nat ) @ N )
      = N ) ).

% plus_nat.add_0
thf(fact_166_add__eq__self__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = M )
     => ( N
        = ( zero_zero @ nat ) ) ) ).

% add_eq_self_zero
thf(fact_167_sfilter_Osimps_I2_J,axiom,
    ! [A: $tType,P: A > $o,S: stream @ A] :
      ( ( stl @ A @ ( sfilter @ A @ P @ S ) )
      = ( sfilter @ A @ P @ ( stl @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P ) @ S ) ) ) ) ).

% sfilter.simps(2)
thf(fact_168_sfilter_Osimps_I1_J,axiom,
    ! [A: $tType,P: A > $o,S: stream @ A] :
      ( ( shd @ A @ ( sfilter @ A @ P @ S ) )
      = ( shd @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P ) @ S ) ) ) ).

% sfilter.simps(1)
thf(fact_169_streams__stl,axiom,
    ! [A: $tType,S: stream @ A,A4: set @ A] :
      ( ( member @ ( stream @ A ) @ S @ ( streams @ A @ A4 ) )
     => ( member @ ( stream @ A ) @ ( stl @ A @ S ) @ ( streams @ A @ A4 ) ) ) ).

% streams_stl
thf(fact_170_streams__shd,axiom,
    ! [A: $tType,S: stream @ A,A4: set @ A] :
      ( ( member @ ( stream @ A ) @ S @ ( streams @ A @ A4 ) )
     => ( member @ A @ ( shd @ A @ S ) @ A4 ) ) ).

% streams_shd
thf(fact_171_streams_Ocases,axiom,
    ! [A: $tType,A2: stream @ A,A4: set @ A] :
      ( ( member @ ( stream @ A ) @ A2 @ ( streams @ A @ A4 ) )
     => ~ ! [A5: A,S6: stream @ A] :
            ( ( A2
              = ( sCons @ A @ A5 @ S6 ) )
           => ( ( member @ A @ A5 @ A4 )
             => ~ ( member @ ( stream @ A ) @ S6 @ ( streams @ A @ A4 ) ) ) ) ) ).

% streams.cases
thf(fact_172_streams_Osimps,axiom,
    ! [A: $tType,A2: stream @ A,A4: set @ A] :
      ( ( member @ ( stream @ A ) @ A2 @ ( streams @ A @ A4 ) )
      = ( ? [A3: A,S3: stream @ A] :
            ( ( A2
              = ( sCons @ A @ A3 @ S3 ) )
            & ( member @ A @ A3 @ A4 )
            & ( member @ ( stream @ A ) @ S3 @ ( streams @ A @ A4 ) ) ) ) ) ).

% streams.simps
thf(fact_173_streams__Stream,axiom,
    ! [A: $tType,X: A,S: stream @ A,A4: set @ A] :
      ( ( member @ ( stream @ A ) @ ( sCons @ A @ X @ S ) @ ( streams @ A @ A4 ) )
      = ( ( member @ A @ X @ A4 )
        & ( member @ ( stream @ A ) @ S @ ( streams @ A @ A4 ) ) ) ) ).

% streams_Stream
thf(fact_174_streams_Ocoinduct,axiom,
    ! [A: $tType,X5: ( stream @ A ) > $o,X: stream @ A,A4: set @ A] :
      ( ( X5 @ X )
     => ( ! [X4: stream @ A] :
            ( ( X5 @ X4 )
           => ? [A6: A,S7: stream @ A] :
                ( ( X4
                  = ( sCons @ A @ A6 @ S7 ) )
                & ( member @ A @ A6 @ A4 )
                & ( ( X5 @ S7 )
                  | ( member @ ( stream @ A ) @ S7 @ ( streams @ A @ A4 ) ) ) ) )
       => ( member @ ( stream @ A ) @ X @ ( streams @ A @ A4 ) ) ) ) ).

% streams.coinduct
thf(fact_175_smap__streams,axiom,
    ! [A: $tType,B: $tType,S: stream @ A,A4: set @ A,F: A > B,B4: set @ B] :
      ( ( member @ ( stream @ A ) @ S @ ( streams @ A @ A4 ) )
     => ( ! [X4: A] :
            ( ( member @ A @ X4 @ A4 )
           => ( member @ B @ ( F @ X4 ) @ B4 ) )
       => ( member @ ( stream @ B ) @ ( smap @ A @ B @ F @ S ) @ ( streams @ B @ B4 ) ) ) ) ).

% smap_streams
thf(fact_176_sfilter__Stream,axiom,
    ! [A: $tType,P: A > $o,X: A,S: stream @ A] :
      ( ( ( P @ X )
       => ( ( sfilter @ A @ P @ ( sCons @ A @ X @ S ) )
          = ( sCons @ A @ X @ ( sfilter @ A @ P @ S ) ) ) )
      & ( ~ ( P @ X )
       => ( ( sfilter @ A @ P @ ( sCons @ A @ X @ S ) )
          = ( sfilter @ A @ P @ S ) ) ) ) ).

% sfilter_Stream
thf(fact_177_comp__apply,axiom,
    ! [C: $tType,A: $tType,B: $tType] :
      ( ( comp @ B @ A @ C )
      = ( ^ [F2: B > A,G2: C > B,X3: C] : ( F2 @ ( G2 @ X3 ) ) ) ) ).

% comp_apply
thf(fact_178_uminus__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( uminus @ B @ ( type2 @ B ) )
     => ( ( uminus_uminus @ ( A > B ) )
        = ( ^ [A7: A > B,X3: A] : ( uminus_uminus @ B @ ( A7 @ X3 ) ) ) ) ) ).

% uminus_apply
thf(fact_179_double__compl,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( uminus_uminus @ A @ ( uminus_uminus @ A @ X ) )
          = X ) ) ).

% double_compl
thf(fact_180_compl__eq__compl__iff,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ( uminus_uminus @ A @ X )
            = ( uminus_uminus @ A @ Y ) )
          = ( X = Y ) ) ) ).

% compl_eq_compl_iff
thf(fact_181_minus__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( minus @ B @ ( type2 @ B ) )
     => ( ( minus_minus @ ( A > B ) )
        = ( ^ [A7: A > B,B5: A > B,X3: A] : ( minus_minus @ B @ ( A7 @ X3 ) @ ( B5 @ X3 ) ) ) ) ) ).

% minus_apply
thf(fact_182_zero__neq__one,axiom,
    ! [A: $tType] :
      ( ( zero_neq_one @ A @ ( type2 @ A ) )
     => ( ( zero_zero @ A )
       != ( one_one @ A ) ) ) ).

% zero_neq_one
thf(fact_183_diff__self__eq__0,axiom,
    ! [M: nat] :
      ( ( minus_minus @ nat @ M @ M )
      = ( zero_zero @ nat ) ) ).

% diff_self_eq_0
thf(fact_184_diff__0__eq__0,axiom,
    ! [N: nat] :
      ( ( minus_minus @ nat @ ( zero_zero @ nat ) @ N )
      = ( zero_zero @ nat ) ) ).

% diff_0_eq_0
thf(fact_185_zero__natural_Orsp,axiom,
    ( ( zero_zero @ nat )
    = ( zero_zero @ nat ) ) ).

% zero_natural.rsp
thf(fact_186_minus__nat_Odiff__0,axiom,
    ! [M: nat] :
      ( ( minus_minus @ nat @ M @ ( zero_zero @ nat ) )
      = M ) ).

% minus_nat.diff_0
thf(fact_187_diffs0__imp__equal,axiom,
    ! [M: nat,N: nat] :
      ( ( ( minus_minus @ nat @ M @ N )
        = ( zero_zero @ nat ) )
     => ( ( ( minus_minus @ nat @ N @ M )
          = ( zero_zero @ nat ) )
       => ( M = N ) ) ) ).

% diffs0_imp_equal
thf(fact_188_diff__commute,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( minus_minus @ nat @ ( minus_minus @ nat @ I @ J ) @ K )
      = ( minus_minus @ nat @ ( minus_minus @ nat @ I @ K ) @ J ) ) ).

% diff_commute
thf(fact_189_fun__diff__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( minus @ B @ ( type2 @ B ) )
     => ( ( minus_minus @ ( A > B ) )
        = ( ^ [A7: A > B,B5: A > B,X3: A] : ( minus_minus @ B @ ( A7 @ X3 ) @ ( B5 @ X3 ) ) ) ) ) ).

% fun_diff_def
thf(fact_190_fun__Compl__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( uminus @ B @ ( type2 @ B ) )
     => ( ( uminus_uminus @ ( A > B ) )
        = ( ^ [A7: A > B,X3: A] : ( uminus_uminus @ B @ ( A7 @ X3 ) ) ) ) ) ).

% fun_Compl_def
thf(fact_191_comp__eq__dest__lhs,axiom,
    ! [C: $tType,B: $tType,A: $tType,A2: C > B,B2: A > C,C2: A > B,V: A] :
      ( ( ( comp @ C @ B @ A @ A2 @ B2 )
        = C2 )
     => ( ( A2 @ ( B2 @ V ) )
        = ( C2 @ V ) ) ) ).

% comp_eq_dest_lhs
thf(fact_192_comp__eq__elim,axiom,
    ! [C: $tType,B: $tType,D2: $tType,A: $tType,A2: C > B,B2: A > C,C2: D2 > B,D: A > D2] :
      ( ( ( comp @ C @ B @ A @ A2 @ B2 )
        = ( comp @ D2 @ B @ A @ C2 @ D ) )
     => ! [V2: A] :
          ( ( A2 @ ( B2 @ V2 ) )
          = ( C2 @ ( D @ V2 ) ) ) ) ).

% comp_eq_elim
thf(fact_193_comp__eq__dest,axiom,
    ! [C: $tType,B: $tType,D2: $tType,A: $tType,A2: C > B,B2: A > C,C2: D2 > B,D: A > D2,V: A] :
      ( ( ( comp @ C @ B @ A @ A2 @ B2 )
        = ( comp @ D2 @ B @ A @ C2 @ D ) )
     => ( ( A2 @ ( B2 @ V ) )
        = ( C2 @ ( D @ V ) ) ) ) ).

% comp_eq_dest
thf(fact_194_comp__assoc,axiom,
    ! [B: $tType,D2: $tType,C: $tType,A: $tType,F: D2 > B,G: C > D2,H: A > C] :
      ( ( comp @ C @ B @ A @ ( comp @ D2 @ B @ C @ F @ G ) @ H )
      = ( comp @ D2 @ B @ A @ F @ ( comp @ C @ D2 @ A @ G @ H ) ) ) ).

% comp_assoc
thf(fact_195_comp__def,axiom,
    ! [A: $tType,C: $tType,B: $tType] :
      ( ( comp @ B @ C @ A )
      = ( ^ [F2: B > C,G2: A > B,X3: A] : ( F2 @ ( G2 @ X3 ) ) ) ) ).

% comp_def
thf(fact_196_natural_Osize_I1_J,axiom,
    ( ( code_size_natural @ ( zero_zero @ code_natural ) )
    = ( zero_zero @ nat ) ) ).

% natural.size(1)
thf(fact_197_dbl__dec__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K: num] :
          ( ( neg_numeral_dbl_dec @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ K ) ) )
          = ( uminus_uminus @ A @ ( neg_numeral_dbl_inc @ A @ ( numeral_numeral @ A @ K ) ) ) ) ) ).

% dbl_dec_simps(1)
thf(fact_198_dbl__inc__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K: num] :
          ( ( neg_numeral_dbl_inc @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ K ) ) )
          = ( uminus_uminus @ A @ ( neg_numeral_dbl_dec @ A @ ( numeral_numeral @ A @ K ) ) ) ) ) ).

% dbl_inc_simps(1)
thf(fact_199_numeral__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( ( numeral_numeral @ A @ M )
            = ( numeral_numeral @ A @ N ) )
          = ( M = N ) ) ) ).

% numeral_eq_iff
thf(fact_200_numeral__plus__numeral,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( plus_plus @ A @ ( numeral_numeral @ A @ M ) @ ( numeral_numeral @ A @ N ) )
          = ( numeral_numeral @ A @ ( plus_plus @ num @ M @ N ) ) ) ) ).

% numeral_plus_numeral
thf(fact_201_add__numeral__left,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [V: num,W: num,Z2: A] :
          ( ( plus_plus @ A @ ( numeral_numeral @ A @ V ) @ ( plus_plus @ A @ ( numeral_numeral @ A @ W ) @ Z2 ) )
          = ( plus_plus @ A @ ( numeral_numeral @ A @ ( plus_plus @ num @ V @ W ) ) @ Z2 ) ) ) ).

% add_numeral_left
thf(fact_202_neg__numeral__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) )
            = ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( M = N ) ) ) ).

% neg_numeral_eq_iff
thf(fact_203_add__neg__numeral__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( uminus_uminus @ A @ ( plus_plus @ A @ ( numeral_numeral @ A @ M ) @ ( numeral_numeral @ A @ N ) ) ) ) ) ).

% add_neg_numeral_simps(3)
thf(fact_204_diff__numeral__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( minus_minus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( numeral_numeral @ A @ N ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( plus_plus @ num @ M @ N ) ) ) ) ) ).

% diff_numeral_simps(3)
thf(fact_205_diff__numeral__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( minus_minus @ A @ ( numeral_numeral @ A @ M ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( numeral_numeral @ A @ ( plus_plus @ num @ M @ N ) ) ) ) ).

% diff_numeral_simps(2)
thf(fact_206_natural__zero__minus__one,axiom,
    ( ( minus_minus @ code_natural @ ( zero_zero @ code_natural ) @ ( one_one @ code_natural ) )
    = ( zero_zero @ code_natural ) ) ).

% natural_zero_minus_one
thf(fact_207_zero__neq__numeral,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( zero_zero @ A )
         != ( numeral_numeral @ A @ N ) ) ) ).

% zero_neq_numeral
thf(fact_208_neg__numeral__neq__numeral,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) )
         != ( numeral_numeral @ A @ N ) ) ) ).

% neg_numeral_neq_numeral
thf(fact_209_numeral__neq__neg__numeral,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( numeral_numeral @ A @ M )
         != ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) ) ) ).

% numeral_neq_neg_numeral
thf(fact_210_zero__neq__neg__numeral,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( zero_zero @ A )
         != ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) ) ) ).

% zero_neq_neg_numeral
thf(fact_211_one__plus__numeral__commute,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [X: num] :
          ( ( plus_plus @ A @ ( one_one @ A ) @ ( numeral_numeral @ A @ X ) )
          = ( plus_plus @ A @ ( numeral_numeral @ A @ X ) @ ( one_one @ A ) ) ) ) ).

% one_plus_numeral_commute
thf(fact_212_numeral__neq__neg__one,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( numeral_numeral @ A @ N )
         != ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% numeral_neq_neg_one
thf(fact_213_one__neq__neg__numeral,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( one_one @ A )
         != ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) ) ) ).

% one_neq_neg_numeral
thf(fact_214_semiring__norm_I168_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [V: num,W: num,Y: A] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ V ) ) @ ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ W ) ) @ Y ) )
          = ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( plus_plus @ num @ V @ W ) ) ) @ Y ) ) ) ).

% semiring_norm(168)
thf(fact_215_natural_Osimps_I4_J,axiom,
    ! [T: $tType,F1: T,F22: code_natural > T] :
      ( ( code_case_natural @ T @ F1 @ F22 @ ( zero_zero @ code_natural ) )
      = F1 ) ).

% natural.simps(4)
thf(fact_216_iterate_Oinduct,axiom,
    ! [A: $tType,B: $tType,P: code_natural > ( B > A > ( product_prod @ B @ A ) ) > B > $o,A0: code_natural,A1: B > A > ( product_prod @ B @ A ),A22: B] :
      ( ! [K2: code_natural,F3: B > A > ( product_prod @ B @ A ),X4: B] :
          ( ! [Xa: B] :
              ( ( K2
               != ( zero_zero @ code_natural ) )
             => ( P @ ( minus_minus @ code_natural @ K2 @ ( one_one @ code_natural ) ) @ F3 @ Xa ) )
         => ( P @ K2 @ F3 @ X4 ) )
     => ( P @ A0 @ A1 @ A22 ) ) ).

% iterate.induct
thf(fact_217_diff__numeral__special_I5_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( minus_minus @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ ( numeral_numeral @ A @ N ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( inc @ N ) ) ) ) ) ).

% diff_numeral_special(5)
thf(fact_218_add__neg__numeral__special_I6_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( inc @ M ) ) ) ) ) ).

% add_neg_numeral_special(6)
thf(fact_219_add__neg__numeral__special_I5_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( inc @ N ) ) ) ) ) ).

% add_neg_numeral_special(5)
thf(fact_220_diff__numeral__special_I6_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num] :
          ( ( minus_minus @ A @ ( numeral_numeral @ A @ M ) @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
          = ( numeral_numeral @ A @ ( inc @ M ) ) ) ) ).

% diff_numeral_special(6)
thf(fact_221_add__inc,axiom,
    ! [X: num,Y: num] :
      ( ( plus_plus @ num @ X @ ( inc @ Y ) )
      = ( inc @ ( plus_plus @ num @ X @ Y ) ) ) ).

% add_inc
thf(fact_222_numeral__inc,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [X: num] :
          ( ( numeral_numeral @ A @ ( inc @ X ) )
          = ( plus_plus @ A @ ( numeral_numeral @ A @ X ) @ ( one_one @ A ) ) ) ) ).

% numeral_inc
thf(fact_223_natural_Osize_I3_J,axiom,
    ( ( size_size @ code_natural @ ( zero_zero @ code_natural ) )
    = ( zero_zero @ nat ) ) ).

% natural.size(3)
thf(fact_224_diff__numeral__special_I3_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( minus_minus @ A @ ( one_one @ A ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( numeral_numeral @ A @ ( plus_plus @ num @ one2 @ N ) ) ) ) ).

% diff_numeral_special(3)
thf(fact_225_one__eq__numeral__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( ( one_one @ A )
            = ( numeral_numeral @ A @ N ) )
          = ( one2 = N ) ) ) ).

% one_eq_numeral_iff
thf(fact_226_numeral__eq__one__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( ( numeral_numeral @ A @ N )
            = ( one_one @ A ) )
          = ( N = one2 ) ) ) ).

% numeral_eq_one_iff
thf(fact_227_numeral__eq__neg__one__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) )
            = ( uminus_uminus @ A @ ( one_one @ A ) ) )
          = ( N = one2 ) ) ) ).

% numeral_eq_neg_one_iff
thf(fact_228_neg__one__eq__numeral__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( ( uminus_uminus @ A @ ( one_one @ A ) )
            = ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( N = one2 ) ) ) ).

% neg_one_eq_numeral_iff
thf(fact_229_numeral__plus__one,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( plus_plus @ A @ ( numeral_numeral @ A @ N ) @ ( one_one @ A ) )
          = ( numeral_numeral @ A @ ( plus_plus @ num @ N @ one2 ) ) ) ) ).

% numeral_plus_one
thf(fact_230_one__plus__numeral,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( plus_plus @ A @ ( one_one @ A ) @ ( numeral_numeral @ A @ N ) )
          = ( numeral_numeral @ A @ ( plus_plus @ num @ one2 @ N ) ) ) ) ).

% one_plus_numeral
thf(fact_231_diff__numeral__special_I4_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num] :
          ( ( minus_minus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( one_one @ A ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( plus_plus @ num @ M @ one2 ) ) ) ) ) ).

% diff_numeral_special(4)
thf(fact_232_add__One,axiom,
    ! [X: num] :
      ( ( plus_plus @ num @ X @ one2 )
      = ( inc @ X ) ) ).

% add_One
thf(fact_233_num__induct,axiom,
    ! [P: num > $o,X: num] :
      ( ( P @ one2 )
     => ( ! [X4: num] :
            ( ( P @ X4 )
           => ( P @ ( inc @ X4 ) ) )
       => ( P @ X ) ) ) ).

% num_induct
thf(fact_234_add__One__commute,axiom,
    ! [N: num] :
      ( ( plus_plus @ num @ one2 @ N )
      = ( plus_plus @ num @ N @ one2 ) ) ).

% add_One_commute
thf(fact_235_numerals_I1_J,axiom,
    ( ( numeral_numeral @ nat @ one2 )
    = ( one_one @ nat ) ) ).

% numerals(1)
thf(fact_236_numeral__One,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ( ( numeral_numeral @ A @ one2 )
        = ( one_one @ A ) ) ) ).

% numeral_One
thf(fact_237_uminus__numeral__One,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( uminus_uminus @ A @ ( numeral_numeral @ A @ one2 ) )
        = ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% uminus_numeral_One
thf(fact_238_diff__numeral__special_I7_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( minus_minus @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( neg_numeral_sub @ A @ N @ one2 ) ) ) ).

% diff_numeral_special(7)
thf(fact_239_diff__numeral__special_I8_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num] :
          ( ( minus_minus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
          = ( neg_numeral_sub @ A @ one2 @ M ) ) ) ).

% diff_numeral_special(8)
thf(fact_240_sub__num__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_sub @ A @ one2 @ one2 )
        = ( zero_zero @ A ) ) ) ).

% sub_num_simps(1)
thf(fact_241_diff__numeral__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( minus_minus @ A @ ( numeral_numeral @ A @ M ) @ ( numeral_numeral @ A @ N ) )
          = ( neg_numeral_sub @ A @ M @ N ) ) ) ).

% diff_numeral_simps(1)
thf(fact_242_add__neg__numeral__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( plus_plus @ A @ ( numeral_numeral @ A @ M ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( neg_numeral_sub @ A @ M @ N ) ) ) ).

% add_neg_numeral_simps(1)
thf(fact_243_add__neg__numeral__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( numeral_numeral @ A @ N ) )
          = ( neg_numeral_sub @ A @ N @ M ) ) ) ).

% add_neg_numeral_simps(2)
thf(fact_244_semiring__norm_I167_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [V: num,W: num,Y: A] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ V ) ) @ ( plus_plus @ A @ ( numeral_numeral @ A @ W ) @ Y ) )
          = ( plus_plus @ A @ ( neg_numeral_sub @ A @ W @ V ) @ Y ) ) ) ).

% semiring_norm(167)
thf(fact_245_semiring__norm_I166_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [V: num,W: num,Y: A] :
          ( ( plus_plus @ A @ ( numeral_numeral @ A @ V ) @ ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ W ) ) @ Y ) )
          = ( plus_plus @ A @ ( neg_numeral_sub @ A @ V @ W ) @ Y ) ) ) ).

% semiring_norm(166)
thf(fact_246_diff__numeral__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( minus_minus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( neg_numeral_sub @ A @ N @ M ) ) ) ).

% diff_numeral_simps(4)
thf(fact_247_diff__numeral__special_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( minus_minus @ A @ ( one_one @ A ) @ ( numeral_numeral @ A @ N ) )
          = ( neg_numeral_sub @ A @ one2 @ N ) ) ) ).

% diff_numeral_special(1)
thf(fact_248_diff__numeral__special_I2_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num] :
          ( ( minus_minus @ A @ ( numeral_numeral @ A @ M ) @ ( one_one @ A ) )
          = ( neg_numeral_sub @ A @ M @ one2 ) ) ) ).

% diff_numeral_special(2)
thf(fact_249_add__neg__numeral__special_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num] :
          ( ( plus_plus @ A @ ( one_one @ A ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) )
          = ( neg_numeral_sub @ A @ one2 @ M ) ) ) ).

% add_neg_numeral_special(1)
thf(fact_250_add__neg__numeral__special_I2_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [M: num] :
          ( ( plus_plus @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( one_one @ A ) )
          = ( neg_numeral_sub @ A @ one2 @ M ) ) ) ).

% add_neg_numeral_special(2)

%----Type constructors (42)
thf(tcon_fun___Lattices_Oboolean__algebra,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( boolean_algebra @ A9 @ ( type2 @ A9 ) )
     => ( boolean_algebra @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Groups_Ouminus,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( uminus @ A9 @ ( type2 @ A9 ) )
     => ( uminus @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Groups_Ominus,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( minus @ A9 @ ( type2 @ A9 ) )
     => ( minus @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add,axiom,
    ordere779506340up_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__comm__monoid__add,axiom,
    cancel1352612707id_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__diff,axiom,
    comm_monoid_diff @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__add,axiom,
    semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0 @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ominus_1,axiom,
    minus @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Num_Onumeral,axiom,
    numeral @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ozero,axiom,
    zero @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oone,axiom,
    one @ nat @ ( type2 @ nat ) ).

thf(tcon_Set_Oset___Lattices_Oboolean__algebra_2,axiom,
    ! [A8: $tType] : ( boolean_algebra @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Groups_Ouminus_3,axiom,
    ! [A8: $tType] : ( uminus @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Groups_Ominus_4,axiom,
    ! [A8: $tType] : ( minus @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_HOL_Obool___Lattices_Oboolean__algebra_5,axiom,
    boolean_algebra @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Groups_Ouminus_6,axiom,
    uminus @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Groups_Ominus_7,axiom,
    minus @ $o @ ( type2 @ $o ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Oordered__ab__semigroup__add_8,axiom,
    ordere779506340up_add @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Ocancel__ab__semigroup__add_9,axiom,
    cancel146912293up_add @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Ocancel__comm__monoid__add_10,axiom,
    cancel1352612707id_add @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Ocancel__semigroup__add_11,axiom,
    cancel_semigroup_add @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Ocomm__monoid__diff_12,axiom,
    comm_monoid_diff @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Oab__semigroup__add_13,axiom,
    ab_semigroup_add @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Ocomm__monoid__add_14,axiom,
    comm_monoid_add @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Rings_Ocomm__semiring__1_15,axiom,
    comm_semiring_1 @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Osemigroup__add_16,axiom,
    semigroup_add @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Rings_Ozero__neq__one_17,axiom,
    zero_neq_one @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Omonoid__add_18,axiom,
    monoid_add @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Ominus_19,axiom,
    minus @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Num_Onumeral_20,axiom,
    numeral @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Ozero_21,axiom,
    zero @ code_natural @ ( type2 @ code_natural ) ).

thf(tcon_Code__Numeral_Onatural___Groups_Oone_22,axiom,
    one @ code_natural @ ( type2 @ code_natural ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $false @ X @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $true @ X @ Y )
      = X ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( koenig1738478187e_plus @ ( koenig1738478187e_plus @ xs @ ys ) @ zs )
    = ( koenig1738478187e_plus @ xs @ ( koenig1738478187e_plus @ ys @ zs ) ) ) ).

%------------------------------------------------------------------------------
